// Pom1 Apple 1 Emulator
// Copyright (C) 2000 Verhille Arnaud
// Copyright (C) 2006 John D. Corrado
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "screen.h"
#include "memory.h"
#include "configuration.h"

void loadConfiguration(void)
{
	FILE *fd = fopen("pom1.cfg", "r");
	char buffer[256], *value;

	if (fd)
	{
		while (!feof(fd))
		{
			if (!fgets(buffer, 256, fd))
				continue;

			if (buffer[0] == '/' || buffer[0] == '\n')
				continue;

			*(strrchr(buffer, '\n')) = '\0';
			value = strrchr(buffer, '=') + 1;
			*(strrchr(buffer, '=')) = '\0';

			if (!strcmp(buffer, "pixelSize"))
				setPixelSize(value[0] & 0x03);
			else if (!strcmp(buffer, "scanline"))
				setScanline(value[0] & 0x01);
			else if (!strcmp(buffer, "terminalSpeed"))
				setTerminalSpeed(atoi(value));
			else if (!strcmp(buffer, "ram8k"))
				setRam8k(value[0] & 0x01);
			else if (!strcmp(buffer, "writeInRom"))
				setWriteInRom(value[0] & 0x01);
			else if (!strcmp(buffer, "fullscreen"))
				setFullScreen(value[0] & 0x01);
		}

		fclose(fd);
	}
}

void saveConfiguration(void)
{
	FILE *fd = fopen("pom1.cfg", "w");
	char buffer[256], terminalSpeed[11];

	strcpy(buffer, "// Pom1 Configuration - Do not change\n");
	fputs(buffer, fd);

	strcpy(buffer, "pixelSize=");
	buffer[10] = getPixelSize() | 0x30;
	buffer[11] = '\n';
	buffer[12] = '\0';
	fputs(buffer, fd);

	strcpy(buffer, "scanline=");
	buffer[9] = getScanline() | 0x30;
	buffer[10] = '\n';
	buffer[11] = '\0';
	fputs(buffer, fd);

	strcpy(buffer, "terminalSpeed=");
	sprintf(terminalSpeed, "%d", getTerminalSpeed());
	strcat(buffer, terminalSpeed);
	strcat(buffer, "\n");
	fputs(buffer, fd);

	strcpy(buffer, "ram8k=");
	buffer[6] = getRam8k() | 0x30;
	buffer[7] = '\n';
	buffer[8] = '\0';
	fputs(buffer, fd);

	strcpy(buffer, "writeInRom=");
	buffer[11] = getWriteInRom() | 0x30;
	buffer[12] = '\n';
	buffer[13] = '\0';
	fputs(buffer, fd);

	strcpy(buffer, "fullscreen=");
	buffer[11] = getFullScreen() | 0x30;
	buffer[12] = '\n';
	buffer[13] = '\0';
	fputs(buffer, fd);

	fclose(fd);
}
